(***********************************************************************

                    Mathematica-Compatible Notebook

This notebook can be used on any computer system with Mathematica 4.0,
MathReader 4.0, or any compatible application. The data for the notebook 
starts with the line containing stars above.

To get the notebook into a Mathematica-compatible application, do one of 
the following:

* Save the data starting with the line of stars above into a file
  with a name ending in .nb, then open the file inside the application;

* Copy the data starting with the line of stars above to the
  clipboard, then use the Paste menu command inside the application.

Data for notebooks contains only printable 7-bit ASCII and can be
sent directly in email or through ftp in text mode.  Newlines can be
CR, LF or CRLF (Unix, Macintosh or MS-DOS style).

NOTE: If you modify the data for this notebook not in a Mathematica-
compatible application, you must delete the line below containing the 
word CacheID, otherwise Mathematica-compatible applications may try to 
use invalid cache data.

For more information on notebooks and Mathematica-compatible 
applications, contact Wolfram Research:
  web: http://www.wolfram.com
  email: info@wolfram.com
  phone: +1-217-398-0700 (U.S.)

Notebook reader applications are available free of charge from 
Wolfram Research.
***********************************************************************)

(*CacheID: 232*)


(*NotebookFileLineBreakTest
NotebookFileLineBreakTest*)
(*NotebookOptionsPosition[     18670,        537]*)
(*NotebookOutlinePosition[     19513,        564]*)
(*  CellTagsIndexPosition[     19469,        560]*)
(*WindowFrame->Normal*)



Notebook[{
Cell[BoxData[
    \( (*\ Example\ 6.4  .1\ \  : \ To\ compute\ e_Q\  = \ \(intx\  - \ int\n
        \tor\ \ e_Q\  = \ int\  - \ intx\)\ \ *) \)], "Input"],

Cell[BoxData[
    \(\(g[s_] := \ x*s + 3\ s^2; \)\)], "Input"],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ Directly\ by\ Mma\ \ *) \n
    intx = Integrate[g[s], \ {s, \ 0, \ 1}] // N\)\)], "Input"],

Cell[BoxData[
    \(\(1.`\[InvisibleSpace]\) + 0.5`\ x\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(\( (*\ By\ rectangular\ rule\ n = 2\ *) \n
    int = \((1/2)\)*\((g[0.5] + g[1])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 1\)\)], "Input"],

Cell[BoxData[
    \(1.125`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Rectangular\ rule, \ n = 4\ *) \n
    int = \((1/4)\)*\((\ g[0.25] + g[0.5] + g[0.75] + g[1])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.53125`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Rectangular\ rule\ n = 10*) \n
    int = \((1/10)\)*
          \((g[0.1] + g[0.2] + g[0.3] + g[0.4] + g[0.5] + g[0.6] + g[0.7] + 
              g[0.8] + g[0.9] + g[1])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.205000000000000071`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Rectangular\ rule\ n = 20*) \n
    int = \((1/20)\)*
          \((g[0.05] + g[0.1] + g[0.15] + g[0.2] + g[0.25] + g[0.3] + 
              g[0.35] + g[0.4] + g[0.45] + g[0.5] + g[0.55] + g[0.6] + 
              g[0.65] + g[0.7] + g[0.75] + g[0.8] + g[0.85] + g[0.9] + 
              g[0.95] + g[1])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.10124999999999984`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Rectangular\ rule\ n = 40*) \n
    int = \((1/40)\)*
          \((g[0.025] + g[0.05] + g[0.075] + g[0.1] + g[0.125] + g[0.15] + 
              g[0.175] + g[0.2] + g[0.225] + g[0.25] + g[0.275] + g[0.3] + 
              g[0.325] + g[0.35] + g[0.375] + g[0.4] + g[0.425] + g[0.45] + 
              g[0.475] + g[0.5] + g[0.525] + g[0.55] + g[0.575] + g[0.6] + 
              g[0.625] + g[0.65] + g[0.675] + g[0.7] + g[0.725] + g[0.75] + 
              g[0.775] + g[0.8] + g[0.825] + g[0.85] + g[0.875] + g[0.9] + 
              g[0.925] + g[0.95] + g[0.975] + g[1])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.0503125000000002042`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 5\ *) \n
    int = \((1/10)\)*
          \((\ g[0] + 2*g[0.2] + 2*g[0.4] + 2*g[0.6] + 2*g[0.8] + g[1])\) // 
        Simplify; \neQ = \((int\  - \ intx)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.0200000000000000177`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 10\ *) \n
    int = \((1/20)\)*
          \((\ g[0] + 2*g[0.1] + 2*g[0.2] + 2*g[0.3] + 2*g[0.4] + 2*g[0.5] + 
              2*g[0.6] + 2*g[0.7] + 2*g[0.8] + 2*g[0.9] + g[1])\) // 
        Simplify; \neQ = \((int\  - \ intx)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.00500000000000011546`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 20\ *) \n
    int = \((1/40)\)*
          \((\ g[0] + 2*g[0.05] + 2*g[0.1] + 2*g[0.15] + 2*g[0.2] + 
              2*g[0.25] + 2*g[0.3] + 2*g[0.35] + 2*g[0.4] + 2*g[0.45] + 
              2*g[0.5] + 2*g[0.55] + 2*g[0.6] + 2*g[0.65] + 2*g[0.7] + 
              2*g[0.75] + 2*g[0.8] + 2*g[0.85] + 2*g[0.9] + 2*g[0.95] + g[1])
            \) // Simplify; \neQ = \((int\  - \ intx)\) /. \ x -> 1\)], 
  "Input"],

Cell[BoxData[
    \(0.00124999999999997335`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Trapezoidal\ Rule\ n = 40\ *) \n
    int = \((1/80)\)*
          \((\ g[0] + 2*g[0.025] + 2*g[0.05] + 2*g[0.075] + \n
              \t\t\t\ \ \ \ \ \ 2*g[0.1] + 2*g[0.125] + 2*g[0.15] + 
              2*g[0.175] + 2*g[0.2] + 2*g[0.225] + 2*g[0.25] + 2*g[0.275] + 
              2*g[0.3] + 2*g[0.325] + 2*g[0.35] + 2*g[0.375] + 2*g[0.4] + 
              2*g[0.425] + 2*g[0.45] + 2*g[0.475] + 2*g[0.5] + 2*g[0.525] + 
              2*g[0.55] + 2*g[0.575] + 2*g[0.6] + 2*g[0.625] + 2*g[0.65] + 
              2*g[0.675] + 2*g[0.7] + 2*g[0.725] + 2*g[0.75] + 2*g[0.775] + 
              2*g[0.8] + 2*g[0.825] + 2*g[0.85] + 2*g[0.875] + 2*g[0.9] + 
              2*g[0.925] + 2*g[0.95] + 2*g[0.975] + g[1])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.000312500000000159872`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 5\ *) \n
    int = \((1/15)\)*
          \((\ g[0] + 4*g[0.25] + 2*g[0.5] + 4*g[0.75] + g[1])\) // Simplify; 
    \neQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.299999999999999911`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 7\ *) \n
    int = \(\((1/21)\)*
            \((\ g[0] + 4*g[1/6] + 2*g[1/3] + 4*g[1/2] + \n\t\t\t\t2*g[2/3] + 
                4*g[5/6] + g[1])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.214285714285714412`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 9*) \n
    int = \(\((1/27)\)*
            \((\ g[0] + 4*g[1/8] + 2*g[1/4] + 4*g[3/8] + \n\t\t\t\t2*g[1/2] + 
                4*g[5/8] + 2*g[3/4] + 4*g[7/8] + g[1])\) // Simplify\) // N; 
    \neQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.16666666666666674`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 11*) \n
    int = \(\((1/33)\)*
            \((\ g[0] + 4*g[1/10] + 2*g[1/5] + 4*g[3/10] + \n\t\t\t\t
                2*g[2/5] + 4*g[1/2] + 2*g[3/5] + 4*g[7/10] + 2*g[4/5] + 
                4*g[9/10] + g[1])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.136363636363636464`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 17*) \n
    int = \(\((1/51)\)*
            \((\ g[0] + 4*g[1/16] + 2*g[2/16] + 4*g[3/16] + \n\t\t\t\t
                2*g[4/16] + 4*g[5/16] + 2*g[6/16] + 4*g[7/16] + 2*g[8/16] + 
                4*g[9/16] + 2*g[10/16] + 4*g[11/16] + 2*g[12/16] + 
                4*g[13/16] + 2*g[14/16] + 4*g[15/16] + g[1])\) // Simplify
          \) // N; \neQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.0882352941176471894`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Simpson' s\ Rule\ n = 33*) \n
    int = \(\((1/99)\)*
            \((\ g[0] + 4*g[1/32] + 2*g[2/32] + 4*g[3/32] + \n\t\t\t\t
                2*g[4/32] + 4*g[5/32] + 2*g[6/32] + 4*g[7/32] + 2*g[8/32] + 
                4*g[9/32] + 2*g[10/32] + 4*g[11/32] + 2*g[12/32] + 
                4*g[13/32] + 2*g[14/32] + 4*g[15/32] + 2*g[16/32] + 
                4*g[17/32] + 2*g[18/32] + 4*g[19/32] + 2*g[20/32] + 
                4*g[21/32] + 2*g[22/32] + 4*g[23/32] + 2*g[24/32] + 
                4*g[25/32] + 2*g[26/32] + 4*g[27/32] + 2*g[28/32] + 
                4*g[29/32] + 4*g[30/32] + 4*g[31/32] + g[1])\) // Simplify
          \) // N; \neQ = \((int\  - \ intx)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.0267518939393940335`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Tangential\ Rule\ n = 5\ *) \n
    int = \((1/5)\)*\ \((g[0.1] + g[0.3] + g[0.5] + g[0.7] + g[0.9])\) // 
        Simplify; \neQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.0100000000000001199`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Tangential\ Rule\ n = 10\ *) \n
    int = \(\((1/10)\)*\ 
            \((g[1/20] + g[3/20] + g[5/20] + g[7/20] + g[9/20] + g[11/20] + 
                g[13/20] + g[15/20] + g[17/20] + g[19/20])\) // Simplify\) // 
        N; \neQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.0024999999999999467`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Tangential\ Rule\ n = 20\ *) \n
    int = \(\((1/20)\)*\ 
            \((g[1/40] + g[3/40] + g[5/40] + g[7/40] + g[9/40] + g[11/40] + 
                g[13/40] + g[15/40] + g[17/40] + g[19/40] + g[21/40] + 
                g[23/40] + g[25/40] + g[27/40] + g[29/40] + g[31/40] + 
                g[33/40] + g[35/40] + g[37/40] + g[39/40])\) // Simplify\) // 
        N; \neQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.000624999999999986677`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 7\ *) \n
    int = \(\((3/70)\)*
            \((g[0] + 5*g[1/7] + g[2/7] + 6*g[3/7] + g[4/7] + 5*g[5/7] + 
                2*g[6/7] + g[1])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.200291545189504427`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \nClear[int, \[CurlyPhi]]; 
    \n (*\ Weddle\ Rule\ n = 13\ *) \n
    int = \(\((3/130)\)*
            \((g[0] + 5*g[1/13] + g[2/13] + 6*g[3/13] + g[4/13] + 5*g[5/13] + 
                2*g[6/13] + 5*g[7/13] + g[8/13] + 6*g[9/13] + g[10/13] + 
                5*g[11/13] + 2*g[12/13] + g[1])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.114838416021847855`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 19\ *) \n
    int = \(\((3/190)\)*
            \((g[0] + 5*g[1/19] + g[2/19] + 6*g[3/19] + g[4/19] + 5*g[5/19] + 
                2*g[6/19] + 5*g[7/19] + g[8/19] + 6*g[9/19] + g[10/19] + 
                5*g[11/19] + 2*g[12/19] + \n\t\t\t\t5*g[13/19] + g[14/19] + 
                6*g[15/19] + g[16/19] + 5*g[17/19] + 2*g[18/19] + g[1])\) // 
          Simplify\) // N; \neQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.0803469893570492033`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 25\ *) \n
    int = \(\((3/250)\)*
            \((g[0] + 5*g[1/25] + g[2/25] + 6*g[3/25] + g[4/25] + 5*g[5/25] + 
                2*g[6/25] + 5*g[7/25] + g[8/25] + 6*g[9/25] + g[10/25] + 
                5*g[11/25] + 2*g[12/25] + \n\t\t\t\t5*g[13/25] + g[14/25] + 
                6*g[15/25] + g[16/25] + 5*g[17/25] + 2*g[18/25] + \n\t\t\t\t
                5*g[19/25] + g[20/25] + 6*g[21/25] + g[22/25] + 5*g[23/25] + 
                2*g[24/25] + g[1])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.061766399999999999`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 31\ *) \n
    int = \(\((3/310)\)*
            \((g[0] + 5*g[1/31] + g[2/31] + 6*g[3/31] + g[4/31] + 5*g[5/31] + 
                2*g[6/31] + 5*g[7/31] + g[8/31] + 6*g[9/31] + g[10/31] + 
                5*g[11/31] + 2*g[12/31] + \n\t\t\t\t5*g[13/31] + g[14/31] + 
                6*g[15/31] + g[16/31] + 5*g[17/31] + 2*g[18/31] + \n\t\t\t\t
                5*g[19/31] + g[20/31] + 6*g[21/31] + g[22/31] + 5*g[23/31] + 
                2*g[24/31] + 5*g[25/31] + g[26/31] + 6*g[27/31] + g[28/31] + 
                5*g[29/31] + 2*g[30/31] + g[1])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.0501594441274211266`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 37*) \n
    int = \(\((3/370)\)*
            \((g[0] + 5*g[1/37] + g[2/37] + 6*g[3/37] + g[4/37] + 5*g[5/37] + 
                2*g[6/37] + 5*g[7/37] + g[8/37] + 6*g[9/37] + g[10/37] + 
                5*g[11/37] + 2*g[12/37] + \n\t\t\t\t5*g[13/37] + g[14/37] + 
                6*g[15/37] + g[16/37] + 5*g[17/37] + 2*g[18/37] + \n\t\t\t\t
                5*g[19/37] + g[20/37] + 6*g[21/37] + g[22/37] + 5*g[23/37] + 
                2*g[24/37] + 5*g[25/37] + g[26/37] + 6*g[27/37] + g[28/37] + 
                5*g[29/37] + 2*g[30/37] + \n\t\t\t\t\t\t\t5*g[31/37] + 
                g[32/37] + 6*g[33/37] + g[34/37] + 5*g[35/37] + 2*g[36/37] + 
                g[1])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.0422225731940852888`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Weddle\ Rule\ n = 43*) \n
    int = \(\((3/430)\)*
            \((g[0] + 5*g[1/43] + g[2/43] + 6*g[3/43] + g[4/43] + 5*g[5/43] + 
                2*g[6/43] + 5*g[7/43] + g[8/43] + 6*g[9/43] + g[10/43] + 
                5*g[11/43] + 2*g[12/43] + \n\t\t\t\t5*g[13/43] + g[14/43] + 
                6*g[15/43] + g[16/43] + 5*g[17/43] + 2*g[18/43] + \n\t\t\t\t
                5*g[19/43] + g[20/43] + 6*g[21/43] + g[22/43] + 5*g[23/43] + 
                2*g[24/43] + 5*g[25/43] + g[26/43] + 6*g[27/43] + g[28/43] + 
                5*g[29/43] + 2*g[30/43] + \n\t\t\t\t\t\t\t5*g[31/43] + 
                g[32/43] + 6*g[33/43] + g[34/43] + 5*g[35/43] + 2*g[36/43] + 
                5*g[37/43] + g[38/43] + 6*g[39/43] + g[40/43] + 5*g[41/43] + 
                2*g[42/43] + g[1])\) // Simplify\) // N; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.036453394040776299`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Gauss - Legendre\ rule\ n = 2*) \n
    int = 0.5*\((g[0.2113248654] + g[0.7886751346])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(8.98459084908154181`*^-12\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ Gauss - Legendre\ Rule\ n = 4\ *) \n
    int = 0.1739274226*g[0.0694318442] + 0.3260725774*g[0.3300094782] + 
          0.3260725774*g[0.6699905218] + 0.1739274226*g[0.9305681558] // 
        Simplify; \neQ = \((int\  - \ intx)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(3.70725672382832271`*^-11\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; 
    \n (*\ By\ Chebyshev\ Rule\ n = 4\ , \ 
      chebyshevpoints\ from\ the\ file\ chebyshevpoints . nb\ *) \n
    int = \((1/4)\)*
          \((g[0.0380602337443566263`]\  + \n\t\t\t\t
              g[0.308658283817455281`] + g[0.691341716182543475`] + 
              g[0.961939766255644812`])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.125000000000000666`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; 
    \n (*\ By\ Chebyshev\ Rule\ n = 6\ , \ 
      chebyshevpoints\ from\ the\ file\ chebyshevpoints . nb\ *) \n
    int = \((1/6)\)*
          \((g[0.0170370868554658567`]\  + \n\t\t\t\t
              g[0.146446609406726224`] + g[0.370590477448738297`] + 
              g[0.62940952255127458`] + g[0.853553390593233451`] + 
              g[0.982962913144561944`])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.125000000000001665`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; 
    \n (*\ By\ Chebyshev\ Rule\ n = 8\ , \ 
      chebyshevpoints\ from\ the\ file\ chebyshevpoints . nb\ *) \n
    int = \((1/8)\)*
          \((g[0.00960735979838477582`]\  + \n\t\t\t\t
              g[0.0842651938487273355`] + g[0.222214883490200598`] + 
              g[0.402454838991917007`] + g[0.597545161008159819`] + 
              g[0.777785116509540586`] + g[0.915734806151648328`] + 
              g[0.990392640201421059`])\) // Simplify; \n
    eQ = \((int\  - \ intx)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.124999999999999289`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Newton - Cotes\ rule\ n = 4\ *) \n
    int = \(\((7*g[0] + 32*g[0.25] + 12*g[0.5] + 32*g[0.75] + 7*g[1])\)/90 // 
          N\) // Simplify; \neQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.`\)], "Output"]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
    \(Clear[int]; \n (*\ By\ Newton - Cotes\ rule\ n = 5\ *) \n
    int = \(\((
              19*g[0] + 75*g[0.2] + 50*g[0.4] + 50*g[0.6] + 75*g[0.8] + 
                19*g[1])\)/288 // N\) // Simplify; \n
    eQ = \((intx\  - \ int)\) /. \ x -> 1\)], "Input"],

Cell[BoxData[
    \(0.`\)], "Output"]
}, Open  ]]
},
FrontEndVersion->"4.0 for Macintosh",
ScreenRectangle->{{0, 832}, {0, 604}},
WindowSize->{520, 509},
WindowMargins->{{17, Automatic}, {Automatic, 6}},
MacintoshSystemPageSetup->"\<\
00<0001804P000000]P2:?oQon82n@960dL5:0?l0080001804P000000]P2:001
0000I00000400`<300000BL?00400@0000000000000006P801T1T00000000000
00000000000000000000000000000000\>"
]


(***********************************************************************
Cached data follows.  If you edit this Notebook file directly, not using
Mathematica, you must remove the line containing CacheID at the top of 
the file.  The cache data will then be recreated when you save this file 
from within Mathematica.
***********************************************************************)

(*CellTagsOutline
CellTagsIndex->{}
*)

(*CellTagsIndex
CellTagsIndex->{}
*)

(*NotebookFileOutline
Notebook[{
Cell[1717, 49, 154, 2, 43, "Input"],
Cell[1874, 53, 62, 1, 27, "Input"],

Cell[CellGroupData[{
Cell[1961, 58, 117, 2, 43, "Input"],
Cell[2081, 62, 68, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2186, 68, 175, 3, 59, "Input"],
Cell[2364, 73, 40, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2441, 79, 205, 3, 91, "Input"],
Cell[2649, 84, 42, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[2728, 90, 283, 5, 107, "Input"],
Cell[3014, 97, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3106, 103, 413, 7, 155, "Input"],
Cell[3522, 112, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[3613, 118, 678, 10, 219, "Input"],
Cell[4294, 130, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4387, 136, 241, 4, 91, "Input"],
Cell[4631, 142, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[4724, 148, 312, 5, 123, "Input"],
Cell[5039, 155, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5133, 161, 469, 8, 171, "Input"],
Cell[5605, 171, 57, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[5699, 177, 813, 12, 267, "Input"],
Cell[6515, 191, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6610, 197, 231, 4, 107, "Input"],
Cell[6844, 203, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[6936, 209, 289, 5, 91, "Input"],
Cell[7228, 216, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7320, 222, 309, 5, 107, "Input"],
Cell[7632, 229, 54, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[7723, 235, 353, 6, 123, "Input"],
Cell[8079, 243, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8171, 249, 459, 7, 155, "Input"],
Cell[8633, 258, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[8726, 264, 735, 11, 235, "Input"],
Cell[9464, 277, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9557, 283, 215, 3, 91, "Input"],
Cell[9775, 288, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[9868, 294, 316, 5, 123, "Input"],
Cell[10187, 301, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10280, 307, 460, 7, 155, "Input"],
Cell[10743, 316, 58, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[10838, 322, 276, 5, 107, "Input"],
Cell[11117, 329, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11209, 335, 404, 7, 155, "Input"],
Cell[11616, 344, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[11708, 350, 479, 7, 171, "Input"],
Cell[12190, 359, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12283, 365, 591, 9, 203, "Input"],
Cell[12877, 376, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[12969, 382, 682, 10, 235, "Input"],
Cell[13654, 394, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[13747, 400, 804, 12, 267, "Input"],
Cell[14554, 414, 56, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[14647, 420, 895, 13, 299, "Input"],
Cell[15545, 435, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15637, 441, 202, 3, 91, "Input"],
Cell[15842, 446, 59, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[15938, 452, 293, 4, 123, "Input"],
Cell[16234, 458, 59, 1, 28, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16330, 464, 401, 8, 155, "Input"],
Cell[16734, 474, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[16826, 480, 469, 9, 187, "Input"],
Cell[17298, 491, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[17390, 497, 541, 10, 219, "Input"],
Cell[17934, 509, 55, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18026, 515, 236, 3, 107, "Input"],
Cell[18265, 520, 37, 1, 26, "Output"]
}, Open  ]],

Cell[CellGroupData[{
Cell[18339, 526, 275, 5, 107, "Input"],
Cell[18617, 533, 37, 1, 26, "Output"]
}, Open  ]]
}
]
*)




(***********************************************************************
End of Mathematica Notebook file.
***********************************************************************)

